'use strict';

process.on('uncaughtException', function (error) {
    //process.exit(0);
});

const electron = require('electron');
const fs = require('fs');
const os = require('os');
const mkdirp = require('mkdirp');
const configuration = require('./scripts/configuration.js');
// Module to control application life.
const app = electron.app;
// Module to create native browser window.
const BrowserWindow = electron.BrowserWindow;

console.log(`Running Electron ${process.versions.electron } (node ${process.version})`);

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow;

function createWindow() {
    // Create the browser window.
    mainWindow = new BrowserWindow({
        width: 1920,
        height: 1080,
        minWidth: 1024,
        minHeight: 768,
        frame: true,
        icon: `${__dirname}/images/favicon.ico`,
        webPreferences: {
            experimentalFeatures: true
        }
    });

    // Attach app to the BrowserWindow
    mainWindow.app = app;

    // Install AngularJS Batarang dev tools
    const { default: installExtension, ANGULARJS_BATARANG } = require('electron-devtools-installer');
    installExtension(ANGULARJS_BATARANG)
        .then((name) => console.log(`Added Extension:  ${name}`))
        .catch((err) => console.log('An error occurred: ', err));

    // Implement a getCurrentWindow function
    mainWindow.getCurrentWindow = () => mainWindow;

    // and load the index.html of the app.

    mainWindow.loadURL('file://' + __dirname + '/index.html');

    mainWindow.setMenu(null);

    // Emitted when the window is closed.
    mainWindow.on('closed', function () {
        mainWindow = null;
    });
}

const shouldQuit = app.makeSingleInstance((commandLine, workingDirectory) => {
    // Someone tried to run a second instance, we should focus our window.
    if (mainWindow) {
        if (mainWindow.isMinimized()) mainWindow.restore();
        mainWindow.focus()
    }
});

if (shouldQuit) {
    app.quit()
}
app.on('ready', createWindow);

// Quit when all windows are closed.
app.on('window-all-closed', function () {
    if (process.platform !== 'darwin') {
        app.quit();
    }
});

app.getFolderPath = () => {
    let folder = os.homedir();
    switch (os.platform()) {
        case "win32":
        case "darwin":
            folder += '/Documents/Startup Company/';
            break;
        default:
            folder += '/.config/StartupCompany/';
    }

    return folder;
};

app.saveFile = (fileName, value) => {
    let folder = app.getFolderPath();
    let path = folder + fileName;

    fs.writeFile(path, value, function (err) {
        if (err) {
            mkdirp(folder, err => {
                app.saveFile(fileName, value);
            });
        }
        ;
        console.log(`Saved file: ${fileName} in folder: ${ folder }`);
    });
};

app.loadFile = (fileName, result) => {
    let folder = app.getFolderPath();
    let path = folder + fileName;
    console.log('Reading file: ' + path);

    fs.readFile(path, 'utf8', function (err, data) {
        result(err != null ? null : data);
    });
};

app.deleteFile = fileName => {
    let folder = app.getFolderPath();
    let path = folder + fileName;

    fs.unlink(path, err => {
        if (err != null) console.log(err);
        console.log('Deleted file: ' + path);
    });
};

// Rename old savegames (REMOVE ON RELEASE)
let folder = app.getFolderPath();
fs.readdir(folder, (err, files) => {
    if (files == null) return;
    files.forEach(file => {
        if (file.indexOf('beta8_') > 0) {
            fs.rename(folder + file, folder + file.replace('beta8_', ''))
        }

        if (file.indexOf('beta9_') > 0) {
            fs.rename(folder + file, folder + file.replace('beta9_', ''))
        }
    });
});

app.getSaveGames = result => {
    let folder = app.getFolderPath();
    fs.readdir(folder, (err, files) => {
        result(files);
    });
};

app.getMods = result => {
    let gameFolder = app.getFolderPath();
    fs.readdir(gameFolder + "/mods", (err, folders) => {
        let files = [];

        if (folders == null)  {
            result(files);
            return;
        }

        folders.forEach(folder => {
            let modFolder = `${gameFolder}/mods/${folder}/`;
            let metaFilePath = modFolder + 'mod.json';
            if (fs.existsSync(metaFilePath)) {
                let mod = JSON.parse(fs.readFileSync(metaFilePath));
                mod.startPath = modFolder + "start.js";
                mod.modPath = modFolder;
                files.push(mod);
            }
        });

        result(files);
    });
};

app.restart = () => {
    app.relaunch();
    app.quit();
};

app.openLink = link => {
    electron.shell.openExternal(link);
};

app.on('activate', function () {
    // On OS X it's common to re-create a window in the app when the
    // dock icon is clicked and there are no other windows open.
    if (mainWindow === null) {
        createWindow();
    }
});

// Greenworks
process.activateUvLoop();
app.greenworks = require('./greenworks/greenworks.js');
console.log(app.greenworks.initAPI());
